package w83b.w83bOperacionesPaso.w83bListados.w83bImpugnaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaPendientesExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListPendientesImpug.xls";
		
		InputStream inputStream = W83bTablaPendientesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaImpugnaciones = (ArrayList)contexto.get("W83bListImpugnacionesBean");
        W83bListImpugnacionesBean listadoBean = (W83bListImpugnacionesBean)contexto.get("W83bListadosImpugBean");                     
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                     

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                     

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                     
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                     
        
        HashMap mapaPendientes=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                     

        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                     
        HSSFCell cell = row.createCell((short)3);                     
        row = sheet.getRow((short)4);                     
        cell = row.getCell((short)4);                     
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaPendientes.get("tituloDepEs");                     
        StringBuffer tituloImagenEu =  (StringBuffer)mapaPendientes.get("tituloDepEu");                     
        cell.setCellValue(tituloImagenEu.toString());                     
        
        cell = row.getCell((short)8);                     
        cell.setCellValue(tituloImagenEs.toString());                     
        
        tituloImagenEs = (StringBuffer)mapaPendientes.get("tituloDelelegacionEs");                     
        tituloImagenEu = (StringBuffer)mapaPendientes.get("tituloDelelegacionEu");                     
 
        row = sheet.getRow((short)6);                     
        cell = row.getCell((short)4);                     
        cell.setCellValue(tituloImagenEu.toString());                     
        
        cell = row.getCell((short)8);                     
        cell.setCellValue(tituloImagenEs.toString());                     
        
        row = sheet.getRow((short)9);                     
        cell = row.getCell((short)2);                     
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugPend",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugPend",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());                             
      
        //MAPEO FORMULARIO
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.informes.territorio"));
        cell = row.createCell((short)2); 
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(listadoBean.getDescTerritorio().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //fila 9
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.nimpudesde"));
        cell = row.createCell((short)7); 
        StringBuffer numImDesde = new StringBuffer(listadoBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoBean.getAgnoImpugnacionDesde())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("7"),W83bClsConstantes.DOCE,Short.parseShort("8")));//NOPMD
        	numImDesde.append("/").append(listadoBean.getAgnoImpugnacionDesde());
        	if(StringUtils.isNotEmpty(listadoBean.getNumImpugnacionDesde())){
        		numImDesde.append("/").append(W83bUtilidadesComunes.rellenarCeros(listadoBean.getNumImpugnacionDesde()));
        	}
        }else{
        	numImDesde = new StringBuffer();
        }
        cell.setCellValue(numImDesde.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.nimpuhasta"));
        cell = row.createCell((short)12); 
        StringBuffer numImHasta = new StringBuffer(listadoBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoBean.getAgnoImpugnacionHasta())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("12"),W83bClsConstantes.DOCE,Short.parseShort("13")));//NOPMD
        	numImHasta.append("/").append(listadoBean.getAgnoImpugnacionHasta());
        	if(StringUtils.isNotEmpty(listadoBean.getNumImpugnacionHasta())){
        		numImHasta.append("/").append(W83bUtilidadesComunes.rellenarCeros(listadoBean.getNumImpugnacionHasta()));
        	}
        }else{
        	numImHasta = new StringBuffer();
        }
        cell.setCellValue(numImHasta.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        //fila 10
        row = sheet.getRow((short)13); 
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.fimpugdesde"));
        cell = row.createCell((short)7); 
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaDesde())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("8")));//NOPMD
        	cell.setCellValue(listadoBean.getFechaEntradaDesde());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.fimpughasta"));
        cell = row.createCell((short)12); 
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaHasta())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("12"),W83bClsConstantes.TRECE,Short.parseShort("13")));//NOPMD
        	cell.setCellValue(listadoBean.getFechaEntradaHasta());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        int j=-4;
        String dniArb = "";
        String dniCurr = "";
        int serie = 0;
        for(int i=0;i<listaImpugnaciones.size();i++){
        	W83bListImpugnacionesBean beanCurrent = (W83bListImpugnacionesBean)listaImpugnaciones.get(i);
        	dniCurr = beanCurrent.getDniArbitro();
        	
        	if(!dniCurr.equals(dniArb)){
        		j=j+6;
        		serie = 0;
        		row = sheet.createRow((short)W83bClsConstantes.QUINCE+j);
	            
	            cell = row.createCell((short)0);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE+j,Short.parseShort("0"),W83bClsConstantes.QUINCE+j,Short.parseShort("1")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.listados.arbitroSimple"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)1);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            	            
	            cell = row.createCell((short)2);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.dni"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)3);
	            if(StringUtils.isNotEmpty(beanCurrent.getDniArbitro())){
	            	cell.setCellValue(beanCurrent.getDniArbitro());
	            }
            
	            
	            cell = row.createCell((short)4);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE+j,Short.parseShort("4"),W83bClsConstantes.QUINCE+j,Short.parseShort("7")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.nombreApellidos"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)5);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)6);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)7);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            	            
	            cell = row.createCell((short)8);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE+j,Short.parseShort("8"),W83bClsConstantes.QUINCE+j,Short.parseShort("13")));//NOPMD
	            if(StringUtils.isNotEmpty(beanCurrent.getNombreArbitro())){
	            	cell.setCellValue(beanCurrent.getNombreArbitro());
	            }

	            if(beanCurrent.getNombreArbitro()!=null){
			        if(83<(beanCurrent.getNombreArbitro()).length()){
			        	row.setHeightInPoints((short)(14*((beanCurrent.getNombreArbitro()).length()/83)+1));
			        }
	        	}
        		
        	//Creamos la cabecera de la tabla
            //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
	            row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+j);
	            row.setHeightInPoints((short)W83bClsConstantes.VEINTISEIS);
	            cell = row.createCell((short)0);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("0"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("1")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.impugnaciones.nImpugnacionCorto"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)1);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)2);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("2"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("3")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun", "comun.preavisos.tabla.num_preaviso"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)3);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)4);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("4"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("5")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.numacta"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)5);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)6);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("6"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("9")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)7);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)8);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)9);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)10);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("10"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("11")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fImpugnacionCorto"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)11);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)12);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+j,Short.parseShort("12"),W83bClsConstantes.DIECISIETE+j,Short.parseShort("13")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fechaEnvioArbitroExcelExtraCorto"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)13);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
            
        	}else{
        		j=j+1;
        		serie++;
        	}
        	
        	// Creacin de la fila 1
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+j);
        	cell = row.createCell((short)0);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("0"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("1")));//NOPMD
        	cell.setCellValue(beanCurrent.getTerritorio()+"/"+beanCurrent.getAgnoImpugnacion()+"/"+W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumImpugnacion()));
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)1);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 2
        	cell = row.createCell((short)2);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("2"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("3")));//NOPMD
        	StringBuffer numD = new StringBuffer();//NOPMD
        	if ("2".equals(beanCurrent.getOrderby())){
        		numD = new StringBuffer(beanCurrent.getTerritorio());//NOPMD
        		if(StringUtils.isNotEmpty(beanCurrent.getAgnoActa())){
            		numD.append("/").append(beanCurrent.getAgnoActa());
                	if(StringUtils.isNotEmpty(beanCurrent.getNumActa())){
                		numD.append("/").append(W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumActa()));
                	}
                }else{
                	numD = new StringBuffer();//NOPMD
                }
        	}
        	cell.setCellValue(numD.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)3);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	
        	// Creacin de la fila 3
        	cell = row.createCell((short)4);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("4"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("5")));//NOPMD
        	StringBuffer numH=new StringBuffer();//NOPMD
        	if ("1".equals(beanCurrent.getOrderby())){
        		numH = new StringBuffer(beanCurrent.getTerritorio());//NOPMD
        		if(StringUtils.isNotEmpty(beanCurrent.getAgnoActa())){
            		numH.append("/").append(beanCurrent.getAgnoActa());
                	if(StringUtils.isNotEmpty(beanCurrent.getNumActa())){
                		numH.append("/").append(W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumActa()));
                	}
                }else{
                	numH = new StringBuffer();//NOPMD
                }
        	}
        	cell.setCellValue(numH.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)5);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 4
        	cell = row.createCell((short)6);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("6"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("9")));//NOPMD
        	if(beanCurrent.getRazonSocial()!=null){
        		cell.setCellValue(beanCurrent.getRazonSocial().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)7);
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)8);
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)9);
        	cell.setCellStyle(estiloFila(serie,excel));
        	
        	// Creacin de la fila 5
        	cell = row.createCell((short)10);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("10"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("11")));//NOPMD
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaImpugnacion())){
        		cell.setCellValue(beanCurrent.getFechaImpugnacion().toString());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)11);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));

        	// Creacin de la fila 6
        	cell = row.createCell((short)12);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("12"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("13")));//NOPMD
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaEnvArbi())){
        		cell.setCellValue(beanCurrent.getFechaEnvArbi());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)13);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	if(beanCurrent.getRazonSocial()!=null){
		        if(62<(beanCurrent.getRazonSocial()).length()){
		        	row.setHeightInPoints((short)(20*((beanCurrent.getRazonSocial()).length()/62)+1));
		        }
        	}
        	if(!dniCurr.equals(dniArb)){
        		dniArb = dniCurr;
        	}

        }
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoImpugnacionesPendientes.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}

	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	/**
	 * Estilo cabecera tabla.
	 *
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloCabeceraTabla (W83bUtilidadesExcel excel){
		return excel.styleTextoCabeceraTabla;//NOPMD
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}

}
